/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.ApplyExp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class constant_fold
extends Syntax {
    public static final constant_fold constant_fold = new constant_fold();

    static Object checkConstant(Expression expression, Translator translator) {
        if (expression instanceof QuoteExp) {
            return ((QuoteExp)expression).getValue();
        }
        if (expression instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null || declaration.getFlag(65536)) {
                return Environment.user().get(referenceExp.getName(), null);
            }
            return Declaration.followAliases(declaration).getConstantValue();
        }
        return null;
    }

    public Expression rewrite(Object object2, Translator translator) {
        Expression expression = translator.rewrite(object2);
        if (!(expression instanceof ApplyExp)) {
            return expression;
        }
        ApplyExp applyExp = (ApplyExp)expression;
        Object object3 = kawa.standard.constant_fold.checkConstant(applyExp.getFunction(), translator);
        if (!(object3 instanceof Procedure)) {
            return expression;
        }
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            Object object4 = kawa.standard.constant_fold.checkConstant(expressionArray[n], translator);
            if (object4 == null) {
                return expression;
            }
            objectArray[n] = object4;
        }
        try {
            return new QuoteExp(((Procedure)object3).applyN(objectArray));
        }
        catch (Throwable throwable) {
            expression = translator.syntaxError("caught exception in constant-fold:");
            translator.syntaxError(throwable.toString());
            return expression;
        }
    }

    static {
        constant_fold.setName("constant-fold");
    }
}

