/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class SyntaxForm
implements Externalizable {
    public Object form;
    public TemplateScope scope;

    private SyntaxForm() {
    }

    public static SyntaxForm make(Object form, TemplateScope scope) {
        SyntaxForm sf = new SyntaxForm();
        sf.form = form;
        sf.scope = scope;
        return sf;
    }

    public String toString() {
        return "#<syntax " + this.form + " in #" + this.scope.id + ">";
    }

    public SyntaxForm fromDatum(Object form) {
        SyntaxForm sf = new SyntaxForm();
        sf.form = form;
        sf.scope = this.scope;
        return sf;
    }

    public static Object makeWithTemplate(Object template, Object form) {
        if (form instanceof SyntaxForm) {
            return (SyntaxForm)form;
        }
        if (template instanceof SyntaxForm) {
            SyntaxForm sform = (SyntaxForm)template;
            if (form == sform.form) {
                return sform;
            }
            return sform.fromDatum(form);
        }
        return form;
    }

    public SyntaxForm fromDatumIfNeeded(Object form) {
        if (form == this.form) {
            return this;
        }
        if (form instanceof SyntaxForm) {
            return (SyntaxForm)form;
        }
        return this.fromDatum(form);
    }

    public static Expression rewrite(Object x) {
        Translator tr = (Translator)Compilation.getCurrent();
        return tr.rewrite(x);
    }

    public static Expression rewriteBody(Object x) {
        Translator tr = (Translator)Compilation.getCurrent();
        return tr.rewrite_body(x);
    }

    public boolean isIdentifier() {
        return this.form instanceof String || this.form instanceof Symbol;
    }

    public static boolean freeIdentifierEquals(SyntaxForm id1, SyntaxForm id2) {
        Translator tr = (Translator)Compilation.getCurrent();
        return tr.lexical.lookup(id1.form, -1) == tr.lexical.lookup(id2.form, -1);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.form);
        out.writeObject(this.scope);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.form = in.readObject();
        this.scope = (TemplateScope)in.readObject();
    }
}

