/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4Rsh<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> shift;
    public final Svex<N> x;

    private Vec4Rsh(Svex<N> shift, Svex<N> x) {
        super(FUNCTION, shift, x);
        this.shift = shift;
        this.x = x;
    }

    @Override
    public boolean isLhsUnbounded() {
        return this.shift instanceof SvexQuote && ((SvexQuote)this.shift).val.isIndex() && this.x.isLhsUnbounded();
    }

    @Override
    public boolean isLhs() {
        return this.shift instanceof SvexQuote && ((SvexQuote)this.shift).val.isIndex() && this.x.isLhs();
    }

    @Override
    public Lhs<N> lhsBound(int w) {
        Vec2 shVal = (Vec2)((SvexQuote)this.shift).val;
        int shv = shVal.getVal().intValueExact();
        return this.x.lhsBound(w + shv).rsh(shv);
    }

    @Override
    public Lhs<N> toLhs() {
        Vec2 shVal = (Vec2)((SvexQuote)this.shift).val;
        int shv = shVal.getVal().intValueExact();
        return this.x.toLhs().rsh(shv);
    }

    @Override
    public Svex.MatchRsh<N> matchRsh() {
        Vec4 sval;
        if (this.shift instanceof SvexQuote && (sval = ((SvexQuote)this.shift).val).isVec2() && ((Vec2)sval).getVal().signum() >= 0) {
            return new Svex.MatchRsh(((Vec2)sval).getVal().intValueExact(), this.args[1]);
        }
        return super.matchRsh();
    }

    @Override
    public Svex<N> lhsrewriteAux(SvexManager<N> sm, int shift, int w) {
        int sv;
        Vec4 sval;
        if (this.shift instanceof SvexQuote && (sval = ((SvexQuote)this.shift).val).isVec2() && (sv = ((Vec2)sval).getVal().intValueExact()) >= 0) {
            return this.x.lhsrewriteAux(sm, shift + sv, w).rsh(sm, sv);
        }
        return super.lhsrewriteAux(sm, shift, w);
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        Svex<N> newShift = this.shift.lhsPreproc(sm);
        Svex<N> newX = this.x.lhsPreproc(sm);
        return sm.newCall(FUNCTION, newShift, newX);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_RSH, 2, "4vec-rsh");
        }

        public <N extends SvarName> Vec4Rsh<N> build(Svex<N>[] args) {
            return new Vec4Rsh<N>(args[0], args[1]);
        }

        @Override
        public <N extends SvarName> Svex<N> callStar(SvexManager<N> sm, Svex<N>[] args) {
            BigInteger shV;
            Vec4 shVal;
            assert (args.length == 2);
            Svex<N> sh = args[0];
            if (sh instanceof SvexQuote && (shVal = ((SvexQuote)sh).val).isVec2() && (shV = ((Vec2)shVal).getVal()).signum() >= 0) {
                return args[1].rsh(sm, shV.intValueExact());
            }
            return super.callStar(sm, args);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 shift = args[0];
            Vec4 x = args[1];
            if (shift.isVec2()) {
                int shiftv = ((Vec2)shift).getVal().intValueExact();
                return this.shiftCore(Math.negateExact(shiftv), x);
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> shift = args[0];
            Vec4 shiftVal = shift.xeval(xevalMemoize);
            if (!shiftVal.isVec2()) {
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.MINUS_ONE};
            }
            int shiftV = ((Vec2)shiftVal).getVal().intValueExact();
            return new BigInteger[]{BigIntegerUtil.MINUS_ONE, mask.shiftLeft(shiftV)};
        }
    }
}

