/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.input.Input;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LEFDEF
extends Input<Object> {
    protected static final boolean PLACELEFGEOMETRY = true;
    protected static final boolean PLACELEFEXPORTS = true;
    protected static Map<String, ViaDef> viaDefsFromLEF;
    protected static Map<ArcProto, Double> widthsFromLEF;
    protected static Map<String, Double> layerWidthsFromLEF;
    protected static Map<String, GetLayerInformation> knownLayers;
    protected static Variable.Key prXkey;
    protected static Variable.Key prYkey;
    protected Technology curTech;
    private boolean viaDigitsCombine;

    public static Collection<GetLayerInformation> getKnownLayers() {
        return knownLayers.values();
    }

    public static Map<String, Double> getLayerWidths() {
        return layerWidthsFromLEF;
    }

    LEFDEF(EditingPreferences ep) {
        super(ep);
    }

    protected void initializeLEFDEF(Technology tech) {
        this.curTech = tech;
        this.viaDigitsCombine = false;
        knownLayers = new HashMap<String, GetLayerInformation>();
        viaDefsFromLEF = new HashMap<String, ViaDef>();
    }

    protected GetLayerInformation getLayerInformation(String name, Integer mask) {
        return this.getLayerInformation(name, mask, null);
    }

    protected GetLayerInformation getLayerInformation(String name, Integer mask, Technology tech) {
        GetLayerInformation li;
        Object keyName = name;
        if (mask != null) {
            keyName = (String)keyName + "_MASK_" + mask;
        }
        if ((li = knownLayers.get(keyName)) != null) {
            return li;
        }
        li = tech == null ? new GetLayerInformation(name, mask) : new GetLayerInformation(name, mask, tech);
        knownLayers.put((String)keyName, li);
        return li;
    }

    protected GetLayerInformation getLayerBasedOnNameAndMask(String layer, Integer mask, int unknownLayerHandling) {
        GetLayerInformation gLay = this.getLayerInformation(layer, mask);
        if (gLay.pure == null && mask != null && (gLay = this.getLayerInformation(layer, null)) != null) {
            this.reportWarning("Layer " + layer + ", mask " + mask + " not found, using non-mask version", null);
        }
        if (gLay.pure == null) {
            if (unknownLayerHandling == 0) {
                this.reportError("Layer " + layer + " not found", null);
                return null;
            }
            if (unknownLayerHandling == 1) {
                this.reportWarning("Layer " + layer + " was replaced by DRC layer", null);
                gLay = this.getLayerInformation(Generic.tech().drcLay.getName(), null, Generic.tech());
                assert (gLay != null);
            } else assert (false);
        }
        return gLay;
    }

    protected void reportError(String command, Cell cell) {
        String msg = "Error on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logError(msg, cell, 0);
    }

    protected void reportWarning(String command, Cell cell) {
        String msg = "Warning on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logWarning(msg, cell, 0);
    }

    protected void reportWarning(String command, Geometric geom, Cell cell) {
        String msg = "Warning on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logWarning(msg, geom, cell, null, 0);
    }

    static {
        prXkey = Variable.newKey("ATTR_LEFwidth");
        prYkey = Variable.newKey("ATTR_LEFheight");
    }

    public class GetLayerInformation {
        String name;
        NodeProto pin;
        NodeProto pure;
        ArcProto arc;
        ArcProto.Function arcFun;
        Layer.Function layerFun;
        ArcProto viaArc1;
        ArcProto viaArc2;

        public boolean equals(GetLayerInformation other) {
            if (other == null) {
                return false;
            }
            return this.layerFun == other.layerFun && this.arcFun == other.arcFun;
        }

        public String getName() {
            return this.name;
        }

        public double getWidth(EditingPreferences ep) {
            if (this.arc != null) {
                return this.arc.getDefaultLambdaBaseWidth(ep);
            }
            if (this.pure != null) {
                return this.pure.getDefWidth(ep);
            }
            return 0.0;
        }

        private NodeProto getPureLayerNode(Integer mask) {
            if (LEFDEF.this.curTech == null) {
                return null;
            }
            Iterator<Layer> it = LEFDEF.this.curTech.getLayers();
            while (it.hasNext()) {
                Layer lay = it.next();
                if (lay.getFunction() != this.layerFun) continue;
                if (mask == null) {
                    return lay.getPureLayerNode();
                }
                int num2 = lay.getFunction().getMaskColor();
                if (num2 != mask) continue;
                return lay.getPureLayerNode();
            }
            return null;
        }

        GetLayerInformation(String name, Integer mask) {
            this.initialize(name, mask, null);
        }

        GetLayerInformation(String name, Integer mask, String type) {
            this.initialize(name, mask, type);
        }

        GetLayerInformation(String name, Integer mask, Technology tech) {
            this.initialize(name, mask, null, tech);
        }

        private void initialize(String name, Integer mask, String type) {
            Technology tech = null;
            int colonPos = name.indexOf(58);
            if (colonPos < 0) {
                tech = LEFDEF.this.curTech;
            } else {
                tech = Technology.findTechnology(name.substring(0, colonPos));
                name = name.substring(colonPos + 1);
            }
            this.initialize(name, mask, type, tech);
        }

        private void initialize(String name, Integer mask, String type, Technology tech) {
            Layer lay;
            Iterator<Layer> it;
            Layer lay2;
            this.name = name;
            this.pin = null;
            this.pure = null;
            this.arc = null;
            this.arcFun = ArcProto.Function.UNKNOWN;
            this.layerFun = Layer.Function.UNKNOWN;
            this.viaArc2 = null;
            this.viaArc1 = null;
            if (tech != null && mask == null && (lay2 = tech.findLayer(name)) != null) {
                this.layerFun = lay2.getFunction();
                this.pure = lay2.getPureLayerNode();
                Iterator<ArcProto> it2 = tech.getArcs();
                while (it2.hasNext()) {
                    ArcProto ap = it2.next();
                    Technology.ArcLayer[] parts = ap.getArcLayers();
                    for (int i = 0; i < parts.length; ++i) {
                        if (parts[i].getLayer() != lay2) continue;
                        this.arc = ap;
                        this.arcFun = this.arc.getFunction();
                        this.pin = this.arc.findPinProto();
                        break;
                    }
                    if (this.arc == null) continue;
                    break;
                }
                if (this.pin == null && name.toUpperCase().startsWith("VIA") && !this.setupViaLayer(name.substring(3))) {
                    System.out.println("ERROR: problems matching VIA '" + name + "' found in technology '" + tech.getTechName() + "'");
                }
                if (lay2 == Generic.tech().drcLay) {
                    assert (this.pin == null);
                    this.arc = Generic.tech().universal_arc;
                    this.arcFun = this.arc.getFunction();
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if ((name = name.toUpperCase()).startsWith("POLY")) {
                this.setupPolyLayer(name.substring(4), name);
                return;
            }
            if (name.equals("PO")) {
                this.setupPolyLayer(name, name);
                return;
            }
            if (name.startsWith("PDIF")) {
                this.arcFun = ArcProto.Function.DIFFP;
                this.layerFun = Layer.Function.DIFFP;
                this.pure = this.getPureLayerNode(null);
                this.arc = LEFDEF.this.curTech.getArc(this.arcFun, 0);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.startsWith("NDIF")) {
                this.arcFun = ArcProto.Function.DIFFN;
                this.layerFun = Layer.Function.DIFFN;
                this.pure = this.getPureLayerNode(null);
                this.arc = LEFDEF.this.curTech.getArc(this.arcFun, 0);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.startsWith("PWEL")) {
                this.layerFun = Layer.Function.WELLP;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            if (name.startsWith("NWEL") || name.equals("NW")) {
                this.layerFun = Layer.Function.WELLN;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            if (name.equals("DIFF") || name.equals("OD")) {
                this.arcFun = ArcProto.Function.DIFF;
                this.layerFun = Layer.Function.DIFF;
                this.pure = this.getPureLayerNode(null);
                this.arc = LEFDEF.this.curTech.getArc(this.arcFun, 0);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.equals("NP")) {
                this.layerFun = Layer.Function.IMPLANTN;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            if (name.equals("PP")) {
                this.layerFun = Layer.Function.IMPLANTP;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            if (name.equals("PDK") || name.equals("AP")) {
                this.layerFun = Layer.Function.ART;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            if (name.equals("CONT") || name.equals("CON") || name.equals("CO")) {
                this.layerFun = Layer.Function.CONTACT1;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            int j = 0;
            if (name.startsWith("VIA")) {
                j = 3;
            } else if (name.startsWith("V")) {
                j = 1;
            }
            if (j != 0 && this.setupViaLayer(name.substring(j))) {
                return;
            }
            j = 0;
            if (name.startsWith("METAL")) {
                j = 5;
            } else if (name.startsWith("MET")) {
                j = 3;
            } else if (name.startsWith("M")) {
                j = 1;
            }
            if (j != 0) {
                this.setupMetalLayer(name.substring(j), mask);
                return;
            }
            if (type != null) {
                if (type.equalsIgnoreCase("masterslice")) {
                    name = name.toUpperCase();
                    j = 0;
                    if (name.startsWith("POLY")) {
                        j = 4;
                    } else if (name.startsWith("P")) {
                        j = 1;
                    }
                    this.setupPolyLayer(name.substring(j), name);
                    return;
                }
                if (type.equalsIgnoreCase("cut")) {
                    j = 0;
                    if ((name = name.toUpperCase()).startsWith("VIA")) {
                        j = 3;
                    } else if (name.startsWith("V")) {
                        j = 1;
                    }
                    if (this.setupViaLayer(name.substring(j))) {
                        return;
                    }
                }
                if (type.equalsIgnoreCase("routing")) {
                    j = 0;
                    if (name.startsWith("METAL")) {
                        j = 5;
                    } else if (name.startsWith("MET")) {
                        j = 3;
                    } else if (name.startsWith("M")) {
                        j = 1;
                    }
                    name = name.substring(j);
                    while (name.length() > 0 && !Character.isDigit(name.charAt(0))) {
                        name = name.substring(1);
                    }
                    this.setupMetalLayer(name, mask);
                    return;
                }
            }
            if (LEFDEF.this.curTech != null) {
                it = LEFDEF.this.curTech.getLayers();
                while (it.hasNext()) {
                    lay = it.next();
                    if (!lay.getName().startsWith(name)) continue;
                    this.layerFun = lay.getFunction();
                    this.assignPureNodeBasedOnLay(lay);
                    return;
                }
            }
            if (name.indexOf("OVERLAP") >= 0) {
                if (LEFDEF.this.curTech != null) {
                    it = LEFDEF.this.curTech.getLayers();
                    while (it.hasNext()) {
                        lay = it.next();
                        if (lay.getName().toLowerCase().indexOf("prbound") < 0) continue;
                        this.layerFun = lay.getFunction();
                        this.assignPureNodeBasedOnLay(lay);
                        return;
                    }
                }
                this.layerFun = Layer.Function.ART;
                this.pin = this.pure = this.getPureLayerNode(null);
                return;
            }
            System.out.println("Error: cannot find a layer in technology " + (tech != null ? tech.getTechName() : "") + " named '" + name + "'");
        }

        private void assignPureNodeBasedOnLay(Layer lay) {
            Iterator<PrimitiveNode> pIt = LEFDEF.this.curTech.getNodes();
            while (pIt.hasNext()) {
                Technology.NodeLayer[] layersOnNode;
                PrimitiveNode pn = pIt.next();
                if (pn.getFunction() != PrimitiveNode.Function.NODE || (layersOnNode = pn.getNodeLayers())[0].getLayer() != lay) continue;
                this.pin = this.pure = pn;
                return;
            }
            System.out.println("Error: cannot find a pure layer node in technology " + LEFDEF.this.curTech.getTechName() + " for layer '" + lay.getName() + "'");
        }

        private void setupMetalLayer(String name, Integer mask) {
            int layNum = TextUtils.atoi(name);
            this.arcFun = ArcProto.Function.getMetal(layNum);
            int maskNum = mask == null ? 0 : mask;
            this.layerFun = Layer.Function.getMetal(layNum, maskNum);
            if (this.arcFun == null || this.layerFun == null || LEFDEF.this.curTech == null) {
                return;
            }
            this.arc = LEFDEF.this.curTech.getArc(this.arcFun, maskNum);
            if (this.arc != null) {
                this.pin = this.arc.findPinProto();
            }
            this.pure = this.getPureLayerNode(mask);
        }

        private void setupPolyLayer(String name, String fullName) {
            try {
                int layNum = TextUtils.atoi(name);
                if (layNum == 0) {
                    layNum = 1;
                }
                this.arcFun = ArcProto.Function.getPoly(layNum);
                this.layerFun = Layer.Function.getPoly(layNum);
                if (this.arcFun == null || this.layerFun == null || LEFDEF.this.curTech == null) {
                    return;
                }
                this.arc = LEFDEF.this.curTech.getArc(this.arcFun, 0);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                this.pure = this.getPureLayerNode(null);
            }
            catch (Exception e) {
                System.out.println("ERROR Parsing Polysilicon layer '" + fullName + "'");
            }
        }

        private boolean setupViaLayer(String name) {
            if (LEFDEF.this.curTech == null) {
                return true;
            }
            ArcProto.Function aFunc1 = ArcProto.Function.UNKNOWN;
            ArcProto.Function aFunc2 = ArcProto.Function.UNKNOWN;
            if (name.length() <= 0) {
                aFunc1 = ArcProto.Function.METAL1;
                aFunc2 = ArcProto.Function.METAL2;
            } else if (name.length() <= 1) {
                int level = name.charAt(0) - 48;
                if (level < 0 || level > 9) {
                    return false;
                }
                aFunc1 = level == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level);
                aFunc2 = ArcProto.Function.getMetal(level + 1);
            } else {
                int level1 = name.charAt(0) - 48;
                int level2 = name.charAt(1) - 48;
                if (level1 < 0 || level1 > 9) {
                    return false;
                }
                if (level2 < 0 || level2 > 9) {
                    return false;
                }
                if (!LEFDEF.this.viaDigitsCombine && level2 <= level1) {
                    LEFDEF.this.viaDigitsCombine = true;
                }
                if (LEFDEF.this.viaDigitsCombine) {
                    level1 = level1 * 10 + level2;
                    level2 = level1 + 1;
                }
                aFunc1 = level1 == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level1);
                aFunc2 = ArcProto.Function.getMetal(level2);
            }
            Iterator<Comparable<ArcProto>> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto apTry = it.next();
                if (apTry.getFunction() == aFunc1) {
                    this.viaArc1 = apTry;
                }
                if (apTry.getFunction() != aFunc2) continue;
                this.viaArc2 = apTry;
            }
            if (this.viaArc1 == null || this.viaArc2 == null) {
                return false;
            }
            it = LEFDEF.this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.getNumPorts() != 1) continue;
                PrimitivePort pp = np.getPort(0);
                boolean ap1Found = pp.connectsTo(this.viaArc1);
                boolean ap2Found = pp.connectsTo(this.viaArc2);
                if (!ap1Found || !ap2Found) continue;
                this.pin = np;
                break;
            }
            if (this.pin != null) {
                PrimitiveNode pNp = (PrimitiveNode)this.pin;
                Technology.NodeLayer[] nl = pNp.getNodeLayers();
                Layer viaLayer = null;
                for (int i = 0; i < nl.length; ++i) {
                    Technology.NodeLayer nLay = nl[i];
                    Layer lay = nLay.getLayer();
                    Layer.Function fun = lay.getFunction();
                    if (!fun.isContact()) continue;
                    viaLayer = lay;
                    this.layerFun = fun;
                    break;
                }
                if (viaLayer == null) {
                    return false;
                }
                this.pure = viaLayer.getPureLayerNode();
            }
            return true;
        }
    }

    protected static class ViaDef {
        protected String viaName;
        protected NodeProto via;
        protected GetLayerInformation gLay1;
        protected GetLayerInformation gLay2;
        protected double sX;
        protected double sY;

        public ViaDef(String name, NodeProto np) {
            this.viaName = name;
            this.sY = 0.0;
            this.sX = 0.0;
            this.via = np;
            this.gLay2 = null;
            this.gLay1 = null;
        }
    }
}

