/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DBMath
extends GenMath {
    public static final double GRID = 400.0;
    private static final double EPSILON = 0.0025;
    private static final double HALF_EPSILON = 0.00125;
    private static final double TINYDELTA = 0.002525;

    public static double getEpsilon() {
        return 0.0025;
    }

    public static boolean pointInRect(Point2D pt, Rectangle2D bounds) {
        if (pt instanceof AbstractFixpPoint && bounds instanceof AbstractFixpRectangle) {
            return DBMath.pointInRect((AbstractFixpPoint)pt, (AbstractFixpRectangle)bounds);
        }
        if (pt.getX() < bounds.getMinX() - 0.002525) {
            return false;
        }
        if (pt.getX() > bounds.getMaxX() + 0.002525) {
            return false;
        }
        if (pt.getY() < bounds.getMinY() - 0.002525) {
            return false;
        }
        return !(pt.getY() > bounds.getMaxY() + 0.002525);
    }

    public static boolean pointInRect(AbstractFixpPoint pt, AbstractFixpRectangle bounds) {
        long fixpX = pt.getFixpX();
        long fixpY = pt.getFixpY();
        return bounds.getFixpMinX() <= fixpX && fixpX <= bounds.getFixpMaxX() && bounds.getFixpMinY() <= fixpY && fixpY <= bounds.getFixpMaxY();
    }

    public static boolean pointInsideRect(Point2D pt, Rectangle2D bounds) {
        double ptX = pt.getX();
        double ptY = pt.getY();
        boolean newV = DBMath.isGreaterThan(ptX, bounds.getMinX()) && DBMath.isGreaterThan(bounds.getMaxX(), ptX) && DBMath.isGreaterThan(ptY, bounds.getMinY()) && DBMath.isGreaterThan(bounds.getMaxY(), ptY);
        return newV;
    }

    public static boolean areEquals(double a, double b) {
        return Math.abs(a - b) < 0.002525;
    }

    public static boolean isInBetween(double x2, double a, double b) {
        if (DBMath.isGreaterThan(a, b)) {
            double c = a;
            a = b;
            b = c;
        }
        boolean tooSmall = DBMath.isGreaterThan(a, x2);
        boolean tooBig = DBMath.isGreaterThan(x2, b);
        return !tooSmall && !tooBig;
    }

    public static boolean isInBetweenExclusive(double x2, double a, double b) {
        if (DBMath.isGreaterThan(a, b)) {
            double c = a;
            a = b;
            b = c;
        }
        boolean tooSmall = DBMath.isGreaterThanOrEqualTo(a, x2);
        boolean tooBig = DBMath.isGreaterThanOrEqualTo(x2, b);
        return !tooSmall && !tooBig;
    }

    public static boolean isGreaterThan(double a, double b) {
        return a - b > 0.00125;
    }

    public static boolean isLessThan(double a, double b) {
        return b - a > 0.00125;
    }

    public static boolean isGreaterThanOrEqualTo(double a, double b) {
        return a - b > -0.00125;
    }

    public static boolean isLessThanOrEqualTo(double a, double b) {
        return b - a > -0.00125;
    }

    public static double round(double lambdaValue) {
        double x2 = lambdaValue * 400.0;
        long l = (long)(x2 >= 0.0 ? x2 + 0.49999999999999994 : x2 - 0.49999999999999994);
        return (double)l / 400.0;
    }

    public static long lambdaToGrid(double lambdaValue) {
        double x2 = lambdaValue * 400.0;
        return (long)(x2 >= 0.0 ? x2 + 0.49999999999999994 : x2 - 0.49999999999999994);
    }

    public static long lambdaToSizeGrid(double lambdaValue) {
        double x2 = lambdaValue * 200.0;
        long l = (long)(x2 >= 0.0 ? x2 + 0.49999999999999994 : x2 - 0.49999999999999994);
        return l << 1;
    }

    public static double gridToLambda(double gridValue) {
        return gridValue / 400.0;
    }

    public static void gridAlign(Point2D pt, EDimension alignment) {
        DBMath.gridAlign(pt, alignment, -1);
    }

    public static void gridAlign(Point2D pt, EDimension alignment, int direction) {
        switch (direction) {
            case -1: {
                if (alignment.getWidth() <= 0.0 || alignment.getHeight() <= 0.0) {
                    return;
                }
                long x2 = Math.round(pt.getX() / alignment.getWidth());
                long y = Math.round(pt.getY() / alignment.getHeight());
                pt.setLocation((double)x2 * alignment.getWidth(), (double)y * alignment.getHeight());
                break;
            }
            case 0: {
                if (alignment.getWidth() <= 0.0) {
                    return;
                }
                long x2 = Math.round(pt.getX() / alignment.getWidth());
                pt.setLocation((double)x2 * alignment.getWidth(), pt.getY());
                break;
            }
            case 1: {
                if (alignment.getHeight() <= 0.0) {
                    return;
                }
                long y = Math.round(pt.getY() / alignment.getHeight());
                pt.setLocation(pt.getX(), (double)y * alignment.getHeight());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static boolean areEquals(Point2D a, Point2D b) {
        return DBMath.areEquals(a.getX(), b.getX()) && DBMath.areEquals(a.getY(), b.getY());
    }

    public static boolean isOnLine(Point2D end1, Point2D end2, Point2D pt) {
        Point2D closestPointOnSegment = DBMath.closestPointToSegment(end1, end2, pt);
        return DBMath.areEquals(closestPointOnSegment, pt);
    }

    public static boolean hasRemainder(double a, double divisor) {
        double val = DBMath.round(a / divisor);
        return val % 1.0 != 0.0;
    }

    public static void transformRect(AbstractFixpRectangle bounds, FixpTransform xform) {
        if (!xform.isIdentity()) {
            xform.transform(bounds, bounds);
        }
    }

    public static void transformRect(Rectangle2D bounds, FixpTransform xform) {
        if (!xform.isIdentity()) {
            xform.transform(bounds, bounds);
        }
    }

    public static boolean rectsIntersect(Rectangle2D r1, Rectangle2D r2) {
        if (r2.getMaxX() < r1.getMinX()) {
            return false;
        }
        if (r2.getMinX() > r1.getMaxX()) {
            return false;
        }
        if (r2.getMaxY() < r1.getMinY()) {
            return false;
        }
        return !(r2.getMinY() > r1.getMaxY());
    }
}

