/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Channel;
import java.util.Collection;
import java.util.TreeSet;

public class LayerChannels {
    private TreeSet<Channel> channels = new TreeSet();

    private static void prln(String msg) {
        Utils.prln(msg);
    }

    private boolean isHorizontal() {
        Job.error(this.channels.size() == 0, "can't tell direction because no channels");
        return this.channels.first().isHorizontal();
    }

    public void add(Channel ch) {
        if (ch.hasTracks()) {
            this.channels.add(ch);
        }
    }

    public Collection<Channel> getChannels() {
        return this.channels;
    }

    public Channel findChanOverVertInterval(double x2, double y1, double y2) {
        double yMin = Math.min(y1, y2);
        double yMax = Math.max(y1, y2);
        if (this.channels.size() == 0) {
            return null;
        }
        Job.error(!this.isHorizontal(), "not sure what this means yet");
        for (Channel c : this.channels) {
            Job.error(x2 < c.getMinTrackEnd() || x2 > c.getMaxTrackEnd(), "channels can't cover X");
            if (c.getMaxTrackCenter() < yMin) continue;
            if (c.getMinTrackCenter() > yMax) break;
            return c;
        }
        return null;
    }

    public Channel findVertBridge(Channel horChan1, Channel horChan2, double x1, double x2) {
        if (this.channels.size() == 0) {
            return null;
        }
        Job.error(this.isHorizontal(), "layer must be vertical");
        double yMin = Math.min(horChan1.getMinTrackCenter(), horChan2.getMinTrackCenter());
        double yMax = Math.max(horChan1.getMaxTrackCenter(), horChan2.getMaxTrackCenter());
        double xMin = Math.min(x1, x2);
        double xMax = Math.max(x1, x2);
        double maxOverlap = -1.7976931348623157E308;
        Channel bestChan = null;
        for (Channel c : this.channels) {
            if (yMax > c.getMaxTrackEnd() || yMin < c.getMinTrackEnd()) {
                LayerChannels.prln("channels can't cover Y");
            }
            double startX = Math.max(xMin, c.getMinTrackCenter());
            double endX = Math.min(xMax, c.getMaxTrackCenter());
            double overlap = endX - startX;
            if (!(overlap > maxOverlap)) continue;
            maxOverlap = overlap;
            bestChan = c;
        }
        return bestChan;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Channel c : this.channels) {
            sb.append(c.toString());
        }
        return sb.toString();
    }

    public int numChannels() {
        return this.channels.size();
    }
}

