/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import com.sun.electric.util.math.Orientation;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class BookshelfOutputPlacement
extends BookshelfOutputWriter {
    private static final Bookshelf.BookshelfFiles fileType = Bookshelf.BookshelfFiles.pl;
    private Cell cell;

    public BookshelfOutputPlacement(String genericFileName, Cell cell) {
        super(genericFileName, fileType);
        this.cell = cell;
    }

    public void write() throws IOException {
        Job.getUserInterface().setProgressNote("Placement File: " + this.fileName);
        PrintWriter writer = new PrintWriter(this.fileName);
        writer.println(BookshelfOutput.createBookshelfHeader(fileType));
        Iterator<NodeInst> ini = this.cell.getNodes();
        while (ini.hasNext()) {
            NodeInst ni = ini.next();
            writer.println(ni.getName() + " " + ni.getTrueCenterX() + " " + ni.getTrueCenterY() + " : " + this.getOrientation(ni.getOrient()));
        }
        writer.flush();
        writer.close();
    }

    private String getOrientation(Orientation orient) {
        String result2 = "";
        if (orient.equals(Orientation.IDENT)) {
            result2 = "N";
        } else if (orient.equals(Orientation.R)) {
            result2 = "E";
        } else if (orient.equals(Orientation.RR)) {
            result2 = "S";
        } else if (orient.equals(Orientation.RRR)) {
            result2 = "W";
        }
        return result2;
    }
}

